<?php
/* --------------------------------------------------------------
 EnvironmentLoader.php 2020-02-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Smarty;

/**
 * Class EnvironmentLoader
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class EnvironmentLoader implements LoaderInterface
{
    /**
     * @inheritDoc
     */
    public function load(Smarty $smarty): void
    {
        $devEnvironment = file_exists(__DIR__ . '/../../../../.dev-environment');
        
        $smarty->assign('environment', $devEnvironment ? 'development' : 'production');
        $smarty->assign('suffix', $devEnvironment ? '.min' : '');
    }
}